#include "General.h"
#include "HarvesterShells.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

HarvesterShells::HarvesterShells()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

HarvesterShells::~HarvesterShells()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

void HarvesterShells::OnObjectCreate(void *data,GameObject *obj)
{
	if (Is_Harvester(obj) || Is_Harvester_Preset(obj))
	{
		Attach_Script_Once(obj, "HarvesterShells_Vehicle", "");
	}
}

void HarvesterShells_Vehicle::Killed(GameObject *obj,GameObject *killer)
{
	Vector3 pos = Commands->Get_Position(obj);
	float facing = Commands->Get_Facing(obj);
	GameObject *destroyed;

	destroyed = Commands->Create_Object("Nod_Harvester_Destroyed", pos);

	Commands->Set_Facing(destroyed,facing);
	Commands->Attach_Script(destroyed, "HarvesterShells_Wreckage", Commands->Get_Preset_Name(obj));
}

void HarvesterShells_Wreckage::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,WreckDestroySelfTime,1001);//destroy the wreck after timer expires
	Set_Skin(obj,"Blamo");//needed to avoid destruction of the wreck on vehicle Killed
	Commands->Start_Timer(obj,this,2.0f,1000);//set skin to CNCVehicleHeavy again
	Set_Max_Health(obj,Commands->Get_Health(obj) + Commands->Get_Shield_Strength(obj));
	Set_Max_Shield_Strength(obj,0);
	Commands->Set_Health(obj,100);
	Commands->Disable_Physical_Collisions(obj);
	Commands->Set_Player_Type(obj,-2);
	Set_Death_Points(obj,0);
	Set_Damage_Points(obj,0);
}

void HarvesterShells_Wreckage::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1000)
	{
		Set_Skin(obj,"SkinVehicleLight");
	}
	else if (number == 1001)
	{
		Commands->Destroy_Object(obj);
	}
}

void HarvesterShells_Wreckage::Damaged(GameObject *obj,GameObject *damager,float amount)
{
	if (amount < 0)
	{
		if (Commands->Get_Max_Health(obj) == Commands->Get_Health(obj) && Commands->Get_Max_Shield_Strength(obj) == Commands->Get_Shield_Strength(obj))
		{
			Vector3 pos = Commands->Get_Position(obj);
			pos.Z += 3;
			float facing = Commands->Get_Facing(obj);
			Commands->Destroy_Object(obj);
			Damage_All_Objects_Area(999999,"Laser_NoBuilding",pos,5,0,0);

			GameObject *veh = Commands->Create_Object("CnC_GDI_APC",pos);
			Commands->Set_Model(veh, "v_nod_hrvstr");
			Commands->Set_Facing(veh,facing);
			Commands->Set_Health(veh,1);
			Commands->Set_Shield_Strength(veh,0);
			Commands->Set_Player_Type(veh,-2);
		}
	}
}

ScriptRegistrant<HarvesterShells_Vehicle> HarvesterShells_Vehicle_Registrant("HarvesterShells_Vehicle", "");
ScriptRegistrant<HarvesterShells_Wreckage> HarvesterShells_Wreckage_Registrant("HarvesterShells_Wreckage", "");

HarvesterShells harvesterShells;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &harvesterShells;
}
